//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2016 BY HOLTEK SEMICONDUCTOR INC
//  File Name :	Sys_init.h
// Description: 系統初始化設定
//   Customer : Holtek Demo Code
//Targer Board: BH67F2470_Demo board
//     Note   : 
//___________________________________________________________________
//___________________________________________________________________
#ifndef SYS_INIT_H_
#define SYS_INIT_H_

#define	mac_BeepOn()	{_cton = 1;}
#define	mac_BeepOff()	{_cton = 0;}
#define MemData_Address  0x80

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用變量 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

extern	volatile	u8	gu8v_Beep_Mode;
extern	volatile	u8	gbv_Beep_Count;
extern	volatile	u8	gu8v_500msCount;
extern  volatile __16_type	gu16v_MemData;
extern	volatile	u16  gu16_CorrCount;
extern volatile	u16  gu16_CorrCount2;
extern  volatile __byte_type  gu8_System_flag;
extern volatile	u8	gu8v_SysMode;
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用函數 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
extern void	fun_SysInit();
extern void	fun_Read_eeprom_K_Para();
extern void	fun_Halt();
extern void	fun_PowerOn_Calibrate_Detect();

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Userdefine @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

#define gbv_Flag_Beep  gu8_System_flag.bits.b0
#define gbv_Flag_500ms  gu8_System_flag.bits.b1
#define gbv_Flag_Key_Lock  gu8_System_flag.bits.b2
#define gbv_Flag_Key_SET_HALT  gu8_System_flag.bits.b3
#define gbv_Flag_KEY_Halt_Enable  gu8_System_flag.bits.b4

//					@---------------WDT config---------------@

//					@---------------WDT config---------------@
#define SETWDTDISABLE()				{ _wdtc = 0xA8;}
#define SETWDTTimer_8MS()			{ _wdtc = 0x50;}
#define SETWDTTimer_32MS()			{ _wdtc = 0x51;}
#define SETWDTTimer_128MS()			{ _wdtc = 0x52;}
#define SETWDTTimer_512MS()			{ _wdtc = 0x53;}
#define SETWDTTimer_1024MS()			{ _wdtc = 0x54;}
#define SETWDTTimer_2048MS()			{ _wdtc = 0x55;}
#define SETWDTTimer_4096MS()			{ _wdtc = 0x56;}
#define SETWDTTimer_8192MS()			{ _wdtc = 0x57;}

//					@-------------LVR config--------------@
//					@-------------LED Current-------------@
//					@-------------LVD config--------------@
//					@-------------INT config----------@
//					@-------------EEPROM config----------@
//					@-------------IO config--------------@
//                  @---------------  TM  ---------------@
//                     @--------------TBC-------- - ------@

#define SETTimerBASE0_8MS()			{ _pscr = 0x03; _tb0c = 0x00;}  		//
#define SETTimerBASE0_16MS()			{ _pscr = 0x03; _tb0c = 0x01;}
#define SETTimerBASE0_32MS()			{ _pscr = 0x03; _tb0c = 0x02;}
#define SETTimerBASE0_64MS()			{ _pscr = 0x03; _tb0c = 0x03;}
#define SETTimerBASE0_128MS()		{ _pscr = 0x03; _tb0c = 0x04;}
#define SETTimerBASE0_256MS()		{ _pscr = 0x03; _tb0c = 0x05;}
#define SETTimerBASE0_512MS()		{ _pscr = 0x03; _tb0c = 0x06;}
#define SETTimerBASE0_1024MS()		{ _pscr = 0x03; _tb0c = 0x07;}


#define SETTimerBASE0_ON()			{ _tb0on = 1;}
#define SETTimerBASE0_OFF()			{ _tb0on = 0;}
#define SETTimerBASE0_ISR_ENABLE()	{ _tb0f = 0; _tb0e = 1; }
#define SETTimerBASE0_ISR_DISABLE()	{ _tb0e = 0; }



#define SETTimerBASE1_8MS()			{ _pscr = 0x03; _tb1c = 0x00;}  		//
#define SETTimerBASE1_16MS()			{ _pscr = 0x03; _tb1c = 0x01;}
#define SETTimerBASE1_32MS()			{ _pscr = 0x03; _tb1c = 0x02;}
#define SETTimerBASE1_64MS()			{ _pscr = 0x03; _tb1c = 0x03;}
#define SETTimerBASE1_128MS()		{ _pscr = 0x03; _tb1c = 0x04;}
#define SETTimerBASE1_256MS()		{ _pscr = 0x03; _tb1c = 0x05;}
#define SETTimerBASE1_512MS()		{ _pscr = 0x03; _tb1c = 0x06;}
#define SETTimerBASE1_1024MS()		{ _pscr = 0x03; _tb1c = 0x07;}


#define SETTimerBASE1_ON()			{ _tb1on = 1;}
#define SETTimerBASE1_OFF()			{ _tb1on = 0;}
#define SETTimerBASE1_ISR_ENABLE()	{ _tb1f = 0; _tb1e = 1; }
#define SETTimerBASE1_ISR_DISABLE()	{ _tb1e = 0; }


//						@-------Internal Power config--------@
//						@------------ADC config--------------@
#define Select_TimerCounter_Mode()				{_ad_tmb=0;}
#define Select_RC_TYPE_ADC_Converter_Mode()		{_ad_tmb=1;}
#define R_to_F_OSC_Source_Output0()  			{_chsel=0;}
#define R_to_F_OSC_Source_Output1() 			{_chsel=1;}
#define TimerB_CLK_Source_LIRC2() 				{_tmbsel=0;}
#define TimerB_CLK_Source_R_to_F_OSC() 			{_tmbsel=1;}
#define R_to_F_OSC_RrefMode() 					{_rsel=0;}
#define R_to_F_OSC_RsensorMode() 				{_rsel=1;}
#define ADC_Mode_Interrupt_Source_TIMA() 		{_ovb_ovab=0;}
#define ADC_Mode_Interrupt_Source_TIMB() 		{_ovb_ovab=1;}
#define TimerA_at_EventCountMode() 				{_tm1=0;_tm0=1;}
#define TimerA_at_TimerMode() 					{_tm1=1;_tm0=0;}
#define TimerA_at_PulseWidthMode() 				{_tm1=1;_tm0=1;}

#define TimerA_B_ON() 							{_ton=1;}
#define TimerA_B_OFF() 							{_ton=0;}
#define R_to_F_ADC_ISR_ENABLE() 				{_rtmre=1;_rtmrf=0;}
#define R_to_F_ADC_ISR_DISABLE() 				{_rtmre=0;_rtmrf=0;}
//						@-------------SIM config-------------@
//						@-------------LVD config-------------@
#define SETLVD_ENABLE			{ _lvden =1;}
#define SETLVD_DISABLE			{ _lvden =0;}

#define fSYS_IRC_64kHZ  1

#ifdef fSYS_IRC_128kHZ
#define delay_n_ms(x1)  GCC_DELAY(32*x1)
#endif
#ifdef fSYS_IRC_64kHZ
#define delay_n_ms(x1)  GCC_DELAY(16*x1)
#endif
#ifdef fSYS_IRC_32kHZ
#define delay_n_ms(x1)  GCC_DELAY(8*x1)
#endif


#ifdef fSYS_IRC_128kHZ
#define memory_data_on_1s  312 //fsys=64khz
#endif
#ifdef fSYS_IRC_64kHZ
#define memory_data_on_1s  156 //fsys=64khz
#endif
#ifdef fSYS_IRC_32kHZ
#define memory_data_on_1s  78 //fsys=64khz
#endif


#ifdef fSYS_IRC_128kHZ
#define key_debounce1_40ms  12 //fsys=128khz
#endif
#ifdef fSYS_IRC_64kHZ
#define key_debounce1_40ms  6 //fsys=64khz
#endif
#ifdef fSYS_IRC_32kHZ
#define key_debounce1_40ms  3 //fsys=32khz
#endif

#ifdef fSYS_IRC_128kHZ
#define key_debounce2_10ms  12 //fsys=128khz
#endif
#ifdef fSYS_IRC_64kHZ
#define key_debounce2_10ms  6 //fsys=64khz
#endif
#ifdef fSYS_IRC_32kHZ
#define key_debounce2_10ms  3 //fsys=32khz
#endif


#ifdef fSYS_IRC_128kHZ
#define Beep_3_2_kHZ 10 //fsys=128khz
#endif
#ifdef fSYS_IRC_64kHZ
#define Beep_3_2_kHZ  5 //fsys=64khz
#endif
#ifdef fSYS_IRC_32kHZ
#define Beep_3_2_kHZ  2 //fsys=32khz
#endif


#define DISABLE_Periph_ASAP()	 {	_lcdc 	=	0;/**LCD Disable**/ \
									_cton	=	0;/**CTM Disable**/\
									_pas0	=	0b11000000;/**CTP->PA3**/\
									_pas1	=	0b00000011;}/**CTPB->PA4**/
#endif



